<?php
// Check if the form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Validate form data
    if (isset($_POST['user_id']) && isset($_POST['username']) && isset($_POST['email']) && isset($_POST['is_admin'])) {
        // Extract form data
        $user_id = $_POST['user_id'];
        $username = $_POST['username'];
        $email = $_POST['email'];
        $is_admin = $_POST['is_admin'];

        // Connect to the database
        $conn = new mysqli("localhost", "root", "", "quiz_db");
        if ($conn->connect_error) {
            die("Connection failed: " . $conn->connect_error);
        }

        // Prepare and execute the SQL statement to update the user
        $sql = "UPDATE users SET username=?, email=?, is_admin=? WHERE id=?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssii", $username, $email, $is_admin, $user_id);
        $stmt->execute();

        // Check if the update was successful
        if ($stmt->affected_rows > 0) {
            header("Location: manage_users.php"); // Redirect to manage_users.php
            exit(); // Ensure that subsequent code is not executed after redirection
        } else {
            echo "Error updating user: " . $conn->error;
        }

        // Close the database connection and statement
        $stmt->close();
        $conn->close();
    } else {
        echo "Invalid form data.";
    }
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <title>Rediģēt Lietotāju</title>
    <link rel="stylesheet" type="text/css" href="../style.css">
    <style>
        h1 {
            text-align: center;
            margin-top: 20px;
            font-size: 24px;
        }
        form {
            display: flex;
            flex-direction: column;
            align-items: center;
            width: 100%;
            max-width: 400px;
            margin: 0 auto;
        }
        label, input, button {
            width: 100%;
            padding: 10px;
            margin-bottom: 10px;
        }
        button {
            background-color: #333;
            color: #fff;
            border: none;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }
        button:hover {
            background-color: #555;
        }
    </style>
</head>
<body>
    <?php include('../php/check_admin.php'); ?>

    <!-- Navigācijas josla -->
    <div id="navbar">
        <div id="logo" onclick="redirectToHomePage()">LOGO</div>
        <div id="profileBtn" class="dropdown" onclick="toggleDropdown()">Profils
            <div class="dropdown-content" id="dropdownContent">
                <a href="../html/change_password.html">Mainīt paroli</a>
                <a href="../php/logout.php">Iziet</a>
            </div>
        </div>
    </div>

    <h1>Rediģēt Lietotāju</h1>
    <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
        <?php
        // Datu bāzes savienojums
        $conn = new mysqli("localhost", "root", "", "quiz_db");
        if ($conn->connect_error) {
            die("Savienojums neizdevās: " . $conn->connect_error);
        }

        if (isset($_GET['user_id'])) {
            $user_id = $_GET['user_id'];

            $sql = "SELECT * FROM users WHERE id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("i", $user_id);
            $stmt->execute();
            $result = $stmt->get_result();
            $user = $result->fetch_assoc();

            if ($user) {
                echo '<input type="hidden" name="user_id" value="' . $user['id'] . '">';
                echo '<label for="username">Lietotājvārds:</label>';
                echo '<input type="text" id="username" name="username" value="' . $user['username'] . '" required>';
                echo '<label for="email">E-pasts:</label>';
                echo '<input type="email" id="email" name="email" value="' . $user['email'] . '" required>';
                echo '<label for="is_admin">Administrators:</label>';
                echo '<select id="is_admin" name="is_admin" required>';
                echo '<option value="1"' . ($user['is_admin'] ? ' selected' : '') . '>Jā</option>';
                echo '<option value="0"' . (!$user['is_admin'] ? ' selected' : '') . '>Nē</option>';
                echo '</select>';
            }

            $stmt->close();
        }

        $conn->close();
        ?>
        <button type="submit">Saglabāt</button>
    </form>

    <script src="../js/redirects.js"></script>
</body>
</html>
